package connect4;


import java.awt.Color;

public class Disc
{
	private boolean color; // true is blue, false is red
	
	public Disc(boolean color)
	{
		this.color = color;
	}
	
	public Disc(Color color)
	{
		if(Color.BLUE.equals(color))
			this.color = true;
		else if(Color.RED.equals(color))
			this.color = false;
		else
			throw new IllegalArgumentException("color must be BLUE or RED");
	}
	
	public boolean color()
	{
		return color;
	}
	
	public Color getColor()
	{
		if(color)
			return Color.BLUE;
		else
			return Color.RED;
	}
	
	public String getImageSuffix()
	{
		return color ? "_blue" : "_red";
	}
}