package connect4;

import info.gridworld.grid.BoundedGrid;
import info.gridworld.grid.Location;

public abstract class Player
{
	private BoundedGrid<Disc> board;
	
	public BoundedGrid<Disc> getBoard()
	{
		return board;
	}
	
	public void setBoard(BoundedGrid<Disc> board)
	{
		this.board = new BoundedGrid<Disc>(board.getNumRows(), board.getNumCols());
		for(Location loc : board.getOccupiedLocations())
		    this.board.put(loc, new Disc(board.get(loc).color()));
	}
	
	/**
	 * Returns the column number of the move the player wishes to make
	 * @return the column number of the move
	 */
	public abstract int move();
}
